<?php
/**
 * Implements the following shortcode:
 * [dhwprecentposts numberposts="2" image="false" excerpt="true"]
 * See: https://codex.wordpress.org/Shortcode_API
 * @return string
 */
function dhwprecentposts_shortcode_func($atts) {
	$content = '';
	$a = shortcode_atts(array(
		'numberposts' => '2',
		'image' => 'false',
		'excerpt' => 'true',
	),$atts);

	$args = array( 'numberposts' => $a['numberposts'] );
	$recent_posts = wp_get_recent_posts($args);
	if(count($recent_posts) > 0){
		$content.= '<ul class="dhwp-recent-news-list">';
		foreach( $recent_posts as $recent ){
			$content.= '<li><a href="' . get_permalink($recent["ID"]) . '">';
			if(has_post_thumbnail($recent["ID"])) {
				$img = get_the_post_thumbnail($recent["ID"]);
				$content.= '<span class="dhwp-recent-image">';
				$content.= $img;
				$content.= '</span>'; //.preview-image
			}

			$content.= '<span class="dhwp-recent-headline">'.get_the_title($recent["ID"]).'</span><br> ';

			if($a['excerpt']=='true'){
				if(has_excerpt($recent["ID"])){
					$the_excerpt = get_the_excerpt($recent["ID"]);
				} else {
					$the_excerpt = $recent["post_content"];
					$excerpt_length = 35; //Sets excerpt length by word count
					$the_excerpt = strip_tags(strip_shortcodes($the_excerpt)); //Strips tags and images
					$words = explode(' ', $the_excerpt, $excerpt_length + 1);
					if(count($words) > $excerpt_length) {
						array_pop($words);
						array_push($words, '...');
						$the_excerpt = implode(' ', $words);
					}
				}
				$content.= '<span class="dhwp-recent-excerpt">'.$the_excerpt.'</span>';
			}
			$content.= '</a></li>';
		}
		$content.= '</ul>';
	}
	return $content;
}
add_shortcode('dhwprecentposts','dhwprecentposts_shortcode_func');
?>
